
Function PSMGetComment (psmMain As Control, nMsgId As Integer) As String
    
On Error GoTo PSMGetComment_Error

    psmMain.MessageID = nMsgId
    PSMGetComment = psmMain.Message

PSMGetComment_End:
    Exit Function

PSMGetComment_Error:
    Select Case Err
        Case 20002
            PSMGetComment = "Error"
        Case 20003
            PSMGetComment = ""
    End Select
    Resume PSMGetComment_End

End Function

Sub PSMLoadLanguageList (psmMain As Control, lstLanguageList As Control)
Dim nCount As Integer
    
    For nCount = 0 To psmMain.NberOfSupportedLanguages - 1
        lstLanguageList.AddItem psmMain.SupportedLanguage(nCount)
    Next nCount

End Sub

Function PSMSetLanguage (psmMain As Control, sLanguage As String) As Integer

On Error GoTo PSMSetLanguage_Error

    PSMSetLanguage = True
    psmMain.Language = LCase$(sLanguage)

PSMSetLanguage_End:
    Exit Function


PSMSetLanguage_Error:
    Select Case Err
        Case 20002
            PSMSetLanguage = False
    End Select
    Resume PSMSetLanguage_End
    
End Function

