Sub PSMCreateLanguageMenu (psmMain As Control, frmMain As Form)
Dim nCount As Integer
    
'Schaut welche Sprachen zu Verfgung stehen und fgt sie im Men 'mnuLanguage' zu

    psmMain.Language = psmMain.SupportedLanguage(0)
    frmMain.mnuLanguage(0).Caption = PSMGetComment(psmMain, MSGLang_Language1)
    
    For nCount = 1 To psmMain.NberOfSupportedLanguages - 1
        psmMain.Language = psmMain.SupportedLanguage(nCount)

        Load frmMain.mnuLanguage(nCount)
        frmMain.mnuLanguage(nCount).Caption = PSMGetComment(psmMain, MSGLang_Language1)
    Next nCount

' Weitere Erkrungen finden Sie im  Visual Basic Programmer's Guide
'                                       Kapitel 4 Menus and Dialogs
'                                                          Seite 89

End Sub

Function PSMGetComment (psmMain As Control, nMsgId As Integer) As String
    
On Error GoTo PSMGetComment_Error

    psmMain.MessageID = nMsgId
    PSMGetComment = psmMain.Message

PSMGetComment_End:
    Exit Function

PSMGetComment_Error:
    Select Case Err
        Case 20002
            PSMGetComment = "Error"
        Case 20003
            PSMGetComment = ""
    End Select
    Resume PSMGetComment_End

End Function

Sub PSMSetAppLanguage (psmMain As Control, frmMain As Form, nLanguageIndex As Integer)
Dim nCount  As Integer
    
' Setzt die gewnschte Sprache der Applikation, "checked" die Sprache im Men
  For nCount = 0 To psmMain.NberOfSupportedLanguages - 1
    If nCount = nLanguageIndex Then
      frmMain.mnuLanguage(nCount).Checked = True
      psmMain.Language = psmMain.SupportedLanguage(nCount)
    Else
      frmMain.mnuLanguage(nCount).Checked = False
    End If
  Next nCount

End Sub

