Option Explicit

'**********************************************************
'   1993 -  Gary Garrison
'           Software Assist Corporation
'**********************************************************

'**********************************************************
'   File Control Structure.
'**********************************************************
Type File_Con
Name            As String
Nbr             As Integer
sz              As Long
c               As Long
End Type

Global Const MAX_REC_LEN = 255
Dim TXTFile     As File_Con
Dim LastRecord  As String
Dim Priorc      As Long

'**********************************************************
'   Misc. flags, etc.
'**********************************************************
Global CRLF     As String

'**********************************************************
'   Supporting Functions.
'**********************************************************
Declare Function LastOC Lib "filespt.dll" (ByVal pStr$, ByVal pChar$) As Long
Declare Function SelectAFile Lib "filespt.dll" (ByVal hWnd%, ByVal dTitle$, ByVal szDefDir$, ByVal szInitFile$, ByVal szDefExt$, ByVal szFilter$) As String
Declare Function Word Lib "filespt.dll" (ByVal pStr$, ByVal cWord%) As String

Function LocateARecord (ByVal c As Long) As String
    Dim wpos As Integer

'**********************************************************
'   If no file is open just exit.
'**********************************************************
    If TXTFile.Nbr = 0 Then Exit Function

'**********************************************************
'   If they are asking to go beyond the end of the file,
'   lie. Pretend we are just 1 character past the end.
'**********************************************************
    If c > TXTFile.sz Then c = TXTFile.sz + 1

'**********************************************************
'   Read a record from the requested position.
'**********************************************************
    If c > 1 Then
	c = c - MAX_REC_LEN
	If c < 1 Then c = 1
	LastRecord = Space$(MAX_REC_LEN)
	Get TXTFile.Nbr, c, LastRecord

'**********************************************************
'   Find the beginning of the last record in LastRecord
'   and read it.
'**********************************************************
	wpos = LastOC(LastRecord, Chr$(10))
	c = c + wpos
    End If
    LastRecord = Space$(MAX_REC_LEN)
    Priorc = c
    Get TXTFile.Nbr, c, LastRecord

'**********************************************************
'   Locate the CRLF at the end of the record.
'**********************************************************
    wpos = InStr(LastRecord, CRLF)
    If wpos = 0 Then
	TXTFile.c = c + Len(LastRecord)
	LocateARecord = LastRecord
    Else
	TXTFile.c = c + wpos + 1
	LocateARecord = Left$(LastRecord, wpos - 1)
	LastRecord = Left$(LastRecord, wpos + 1)
    End If
End Function

Function NextFilePosition () As Long
'**********************************************************
'   Return the next position that would be read in the
'   file.
'**********************************************************
    NextFilePosition = TXTFile.c
End Function

Function OpenAFile () As Long
'**********************************************************
'   Open a file and fill in the File_Con structure for it.
'**********************************************************

    Dim wName As String

    OpenAFile = 0
    CRLF = Chr$(13) + Chr$(10)

'**********************************************************
'   Select the file to browse.
'**********************************************************
    wName = Word(SelectAFile(frmMain.hWnd, "Open a File", CurDir$, "*.*", "TXT", "All Files(*.*)|*.*|"), 1)
    If wName = "" Then Exit Function

'**********************************************************
'   Open up the file and get other info on it.
'**********************************************************
    If TXTFile.Nbr <> 0 Then Close TXTFile.Nbr
    TXTFile.Name = wName
    TXTFile.Nbr = FreeFile
    Open TXTFile.Name For Binary Access Read Lock Write As TXTFile.Nbr
    TXTFile.c = 1
    TXTFile.sz = LOF(TXTFile.Nbr)
    OpenAFile = TXTFile.sz
End Function

Function ReadNextRecord () As String
'**********************************************************
'   Return the next record in the file.
'**********************************************************

    Dim wpos As Integer

'**********************************************************
'   If no file is open or we are at EOF, just exit.
'**********************************************************
    If TXTFile.Nbr = 0 Then Exit Function
    If TXTFile.c > TXTFile.sz Then Exit Function

'**********************************************************
'   Read in the next record.
'**********************************************************
    LastRecord = Space$(MAX_REC_LEN)
    Get TXTFile.Nbr, TXTFile.c, LastRecord

'**********************************************************
'   Locate the CRLF at the end of the record.
'**********************************************************
    Priorc = TXTFile.c
    wpos = InStr(LastRecord, CRLF)
    If wpos = 0 Then
	TXTFile.c = TXTFile.c + Len(LastRecord)
	ReadNextRecord = LastRecord
    Else
	TXTFile.c = TXTFile.c + wpos + 1
	ReadNextRecord = Left$(LastRecord, wpos - 1)
	LastRecord = Left$(LastRecord, wpos + 1)
    End If
End Function

Function ReadPriorRecord () As String
'**********************************************************
'   Return the prior record in the file.
'**********************************************************

    Dim wrec As String
    Dim wc As Long
    Dim wpos As Integer

'**********************************************************
'   If no file is open or we are at BOF, just exit.
'**********************************************************
    If TXTFile.Nbr = 0 Then Exit Function
    If Priorc = 1 Then TXTFile.c = 1
    If TXTFile.c = 1 Then Exit Function

'**********************************************************
'   Read in the prior record.
'**********************************************************
    wc = Priorc - MAX_REC_LEN
    If wc < 1 Then wc = 1
    LastRecord = Space$(Priorc - 2 - wc)
    Get TXTFile.Nbr, wc, LastRecord

'**********************************************************
'   Find the end of the prior record.
'**********************************************************
    wpos = LastOC(LastRecord, Chr$(10))
    If wpos > 0 Then
	LastRecord = Mid$(LastRecord, wpos + 1)
	wc = wc + wpos
    End If
    ReadPriorRecord = LastRecord
    Priorc = wc
    TXTFile.c = wc + Len(LastRecord) + 2
End Function

