' Scroll.Bas:
' Coded by Christian Jrges on September 93

Option Explicit

Declare Sub SetScrollRange Lib "User" (ByVal hWnd As Integer, ByVal nBar As Integer, ByVal nMinPos As Integer, ByVal nMaxPos As Integer, ByVal bRedraw As Integer)
Declare Function SetScrollPos Lib "User" (ByVal hWnd As Integer, ByVal nBar As Integer, ByVal nPos As Integer, ByVal bRedraw As Integer) As Integer

Global Const SB_HORZ = 0
Global Const SB_VERT = 1
Global Const SB_BOTH = 3

Global Const WM_VSCROLL = &H115
Global Const WM_HSCROLL = &H114
Global Const SB_BOTTOM = 7
Global Const SB_ENDSCROLL = 8
Global Const SB_LINEDOWN = 1
Global Const SB_LINEUP = 0
Global Const SB_PAGEDOWN = 3
Global Const SB_PAGEUP = 2
Global Const SB_THUMBPOSITION = 4
Global Const SB_THUMBTRACK = 5
Global Const SB_TOP = 6


Type Rect
    Left As Integer
    Top As Integer
    Right As Integer
    Bottom As Integer
End Type

Declare Sub GetClientRect Lib "User" (ByVal hWnd As Integer, lpRect As Rect)

' Set Pixel for each horizonatal and vertical scrolling

Const ScrollSteps = 12



Dim Shared iThumbTrack As Integer

Sub EnableThumbTrack (iBoolean)

    ' You can also modify iThumbTrack directly....
    
    If iBoolean Then
        iThumbTrack = True
    Else
        iThumbTrack = False
    End If

End Sub

Sub InitScrollPic (PicBox As PictureBox)

    PicBox.Top = 0 ' Set Picture to upper left corner
    PicBox.Left = 0
    
End Sub

Sub Scroll (FormHandle As Form, PicHandle As PictureBox, iMsg As Integer, iwParam As Integer, lParam As Long)

If iMsg <> WM_VSCROLL And iMsg <> WM_HSCROLL Then Exit Sub

Dim FormRect As Rect
Dim iPicTop As Long
Dim iPicHeight As Long
Dim iPicLeft As Long
Dim iPicWidth As Long
Dim iPicVPos As Long
Dim iPicHPos As Long
Dim iOldFormMode As Integer
Dim iOldPicMode As Integer
Dim iOldThumbPos As Integer
Dim iFormHeight As Integer

    iOldFormMode = FormHandle.ScaleMode
    iOldPicMode = PicHandle.ScaleMode
    FormHandle.ScaleMode = 3
    PicHandle.ScaleMode = 3
    GetClientRect FormHandle.hWnd, FormRect
    
    ' Test horizontal or vertical scrollbar...
    
    If iMsg = WM_VSCROLL Then
        iPicTop = PicHandle.Top
        iPicHeight = PicHandle.Height
        iFormHeight = FormRect.Bottom
    Else
        iPicTop = PicHandle.Left
        iPicHeight = PicHandle.Width
        iFormHeight = FormRect.Right
    End If
    
    ' Only one algorithm is needed for both scrollbars
    
    iPicVPos = iPicTop + iPicHeight
    Select Case iwParam
        Case SB_LINEUP
            iPicTop = iPicTop + ScrollSteps
        Case SB_LINEDOWN
            iPicTop = iPicTop - ScrollSteps
        Case SB_PAGEDOWN
            iPicTop = iPicTop - iFormHeight
        Case SB_PAGEUP
            iPicTop = iPicTop + iFormHeight
        Case SB_THUMBPOSITION
            If Not iThumbTrack Then iPicTop = -lParam
        Case SB_THUMBTRACK
            If iThumbTrack Then iPicTop = -lParam

    End Select
    
    ' Are we still inside the picture range ?
    ' If not, correct position
    
    If iPicTop + iPicHeight < iFormHeight Then iPicTop = iFormHeight - iPicHeight
    If iPicTop + iPicHeight > iPicHeight Then iPicTop = 0
    
    ' Now decide again, which scrollbar to handle (sorry for bad english...)

    If iMsg = WM_VSCROLL Then
        PicHandle.Top = iPicTop ' Set new picture position
        If iwParam <> SB_ENDSCROLL Then
            iOldThumbPos = SetScrollPos(FormHandle.hWnd, SB_VERT, Abs(PicHandle.Top), True)
        Else
            SetScrollBar FormHandle, PicHandle
        End If
    Else
        PicHandle.Left = iPicTop
        If iwParam <> SB_ENDSCROLL Then
            iOldThumbPos = SetScrollPos(FormHandle.hWnd, SB_HORZ, Abs(PicHandle.Left), True)
        Else
            SetScrollBar FormHandle, PicHandle
        End If
     End If
     
    FormHandle.ScaleMode = iOldFormMode
    PicHandle.ScaleMode = iOldPicMode
    
End Sub

Sub SetScrollBar (FormHandle As Form, PicHandle As PictureBox)


Static bWhileSet As Integer
Dim iFormH As Integer
Dim iFormW As Integer
Dim iPicH As Integer
Dim iPicW As Integer
Dim iScrollMode As Integer
Dim FormRect As Rect
Dim iVertMin As Integer
Dim iVertMax As Integer
Dim iHorzMin As Integer
Dim iHorzMax As Integer
Dim iOldThumbPos
Dim iOldFormMode As Integer
Dim iOldPicMode As Integer


If Not bWhileSet Then ' this prevents stack overflow
    bWhileSet = True
    iOldFormMode = FormHandle.ScaleMode
    iOldPicMode = PicHandle.ScaleMode
    ' We need Pixel, because GetClientRect returns in Pixel !
    FormHandle.ScaleMode = 3
    PicHandle.ScaleMode = 3

    iPicW = PicHandle.Width
    iPicH = PicHandle.Height
    
    
    iHorzMin = PicHandle.Left
    iHorzMax = iHorzMin + iPicW - FormRect.Bottom
    iVertMin = PicHandle.Top
    iVertMax = iVertMin + iPicH - FormRect.Left

    GetClientRect FormHandle.hWnd, FormRect ' Get the client size of the window
    
    iFormH = FormRect.Bottom
    iFormW = FormRect.Right
    
    iScrollMode = 0
    
    ' find out if the Picture-Box is bigger then the Window,
    ' or if Picture is still in negativ range...
    
    If iPicH >= iFormH Or iVertMin < 0 Then iScrollMode = 1
    If iPicW >= iFormW Or iHorzMin < 0 Then iScrollMode = iScrollMode + 2

    Select Case iScrollMode
        Case 1
            ' show only vertical scrollbar
            SetScrollRange FormHandle.hWnd, SB_VERT, 0, iPicH - iFormH, False
            iOldThumbPos = SetScrollPos(FormHandle.hWnd, SB_VERT, Abs(iVertMin), True)
            SetScrollRange FormHandle.hWnd, SB_HORZ, 0, 0, False
            
        Case 2
            ' show only horizontal scrollbar
            SetScrollRange FormHandle.hWnd, SB_VERT, 0, 0, False
            SetScrollRange FormHandle.hWnd, SB_HORZ, 0, iPicW - iFormW, False
            iOldThumbPos = SetScrollPos(FormHandle.hWnd, SB_HORZ, Abs(iHorzMin), True)
            
        Case 3
            ' show both scrollbars
            SetScrollRange FormHandle.hWnd, SB_HORZ, 0, iPicW - iFormW, False
            iOldThumbPos = SetScrollPos(FormHandle.hWnd, SB_HORZ, Abs(iHorzMin), True)
            SetScrollRange FormHandle.hWnd, SB_VERT, 0, iPicH - iFormH, False
            iOldThumbPos = SetScrollPos(FormHandle.hWnd, SB_VERT, Abs(iVertMin), True)
            
        Case Else
            ' hide both scrollbars
            SetScrollRange FormHandle.hWnd, SB_VERT, 0, 0, False
            SetScrollRange FormHandle.hWnd, SB_HORZ, 0, 0, False
            
    End Select
    FormHandle.ScaleMode = iOldFormMode
    PicHandle.ScaleMode = iOldPicMode
    bWhileSet = False
End If

End Sub

