
//////////////////////////////////////////////////////////////////////////////
//
// Filename:     skelini.cpp
//
// Description:  Skeleton Visual Basic Custom Control.
//
//               Initialisation (and termination) routines for the VBX (DLL)
//               module.
//
// Date Created: <Date>
//
// Author:       <Your Name>
//
// Copyright (c) <Your Company Name> 1994
//
//               Portions of this product are based on original
//                  source code from Anton Software Limited.
//
//////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <vbapi.h>

#include "skeleton.hpp"
#include "skelexp.hpp"
#include "skelext.hpp"

//////////////////////////////////////////////////////////////////////////////
//
// Local data
//
//////////////////////////////////////////////////////////////////////////////

// Number of programs currently using the VBX module.
static WORD cVBXUsers = 0;

// Whether the about box's controlling window class has been registered.
static BOOL fAboutClassRegistered = FALSE;

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: LibMain
//
// Description:   Called by the system when the first client program loads the
//                control.
//
// Parameters:    hModule    - library instance handle
//                wDataSeg   - library data segment
//                cbHeapSize - default heap size
//                lszCmdLine - command line arguments
//
// Return Code:   1 to indicate success
//
//////////////////////////////////////////////////////////////////////////////

int CALLBACK LibMain
(
    HANDLE     hModule,     // library instance handle
    WORD,   // wDataSeg,    // library data segment
    WORD,   // cbHeapSize,  // default heap size
    LPSTR   // lpszCmdLine  // command line arguments
)
{
    // Save the module handle (used in VBINITCC()).
    hmodDLL = hModule;

    // Return 1 to indicate success.
    return 1;

} // LibMain

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBGetModelInfo
//
// Description:   Provides custom control model information to the host
//                environment (Visual Basic).
//
// Parameters:    uVersion - Visual Basic version
//
// Return Code:   Long pointer to the model information
//
//////////////////////////////////////////////////////////////////////////////

LPMODELINFO CALLBACK _export VBGetModelInfo
(
    USHORT uVersion     // Visual Basic version
)
{
    // Don't bother to support VB1 (or, therefore, VC++).
    if (uVersion == VB100_VERSION)
        return NULL;

    // Return the model information.
    return (LPMODELINFO)&modelinfoSkeleton;

} // VBGetModelInfo

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBINITCC
//
// Description:   Called by Visual Basic when the custom control DLL is loaded
//                for use by each application. Registers the custom control.
//
// Parameters:    uVersion - Visual Basic version
//                fRuntime - whether run time
//
// Return Code:   TRUE if registering the control was successful; FALSE
//                otherwise.
//
//////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK _export VBINITCC
(
    USHORT    uVersion,     // Visual Basic version
    BOOL   // fRuntime      // whether run time
)
{
    // Don't bother to support VB1 (or, therefore, VC++).
    if (uVersion == VB100_VERSION)
    {
        MessageBox(0,
                   "VB1 and VC++ are not supported. " \
                   "Please use VB2 or above.\n",
                   lpstrMsgBoxTitle,
                   MB_ICONSTOP);

        return FALSE;

    } // end if being loaded by VB1 (or VC++)

    // Register the about box's invisible controlling window class (if not
    // already registered)...
    if (!fAboutClassRegistered)
    {
        WNDCLASS WndClass;

        WndClass.style         = 0;
        WndClass.lpfnWndProc   = (WNDPROC)AboutWndProc;
        WndClass.cbClsExtra    = 0;
        WndClass.cbWndExtra    = 0;
        WndClass.hInstance     = hmodDLL;
        WndClass.hIcon         = NULL;
        WndClass.hCursor       = NULL;
        WndClass.hbrBackground = NULL;
        WndClass.lpszMenuName  = NULL;
        WndClass.lpszClassName = lpstrAboutBoxParent;

        if (RegisterClass(&WndClass) == 0)
            return FALSE;

        fAboutClassRegistered = TRUE;

    } // end if the about control window class is not already registered

    // Increment the count of programs using the VBX module.
    cVBXUsers++;

    // Finally, return the result from registering the control's model.
    return VBRegisterModel(hmodDLL, (LPMODEL)&modelSkeleton);

} // VBINITCC

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBTERMCC
//
// Description:   An optional routine that is the opposite of VBINITCC(). Is
//                called by VB when an application unloads the control.
//
// Parameters:    None
//
// Return Code:   None
//
//////////////////////////////////////////////////////////////////////////////

VOID CALLBACK _export VBTERMCC(void)
{
    // Decrement the count of programs using the VBX module.
    cVBXUsers--;

    // Unregister the about box's controlling window class if no more users.
    if ((cVBXUsers == 0) && fAboutClassRegistered)
    {
        UnregisterClass(lpstrAboutBoxParent, hmodDLL);
        fAboutClassRegistered = FALSE;
    }

} // VBTERMCC

