': 2-GROUPS.BAS
'-
'- Manages two groups, left and right
'-
Option Explicit

Sub tgp_addLeftSide (ByVal s As String)

   fmtTwoGroups!lstLeft.AddItem s

End Sub

Sub tgp_addRightSide (ByVal s As String)

   fmtTwoGroups!lstRight.AddItem s

End Sub

Sub tgp_end ()

   Unload fmtTwoGroups

End Sub

Sub tgp_initialize (ByVal windowTitle_s As String, ByVal leftTitle_s As String, ByVal rightTitle_s As String)
   
   Load fmtTwoGroups

   fmtTwoGroups.Caption = windowTitle_s

   'Setup Left lable and listbox
   If leftTitle_s <> "" Then
      fmtTwoGroups.lblLeft.Caption = leftTitle_s
   Else
      fmtTwoGroups.lblLeft.Visible = False
   End If
   fmtTwoGroups!lstLeft.Clear

   'Setup Right lable and listbox
   If rightTitle_s <> "" Then
      fmtTwoGroups.lblRight.Caption = rightTitle_s
   Else
      fmtTwoGroups.lblRight.Visible = False
   End If
   fmtTwoGroups!lstRight.Clear

End Sub

Function tgp_LeftList_s (ByVal listIndex As Integer) As String

   tgp_LeftList_s = fmtTwoGroups!lstLeft.List(listIndex)

End Function

Function tgp_RightList_s (ByVal listIndex As Integer) As String
   
   tgp_RightList_s = fmtTwoGroups!lstRight.List(listIndex)

End Function

Sub tgp_SetLeftListSorted (ByVal sorted_b As Integer)
   
   'fmtTwoGroups!lstRight.Sorted = sorted_b

End Sub

Sub tgp_SetRightListSorted (ByVal sorted_b As Integer)

   'fmtTwoGroups!lstRight.Sorted = sorted_b

End Sub

Function tgp_ShowForm_s () As String

' Returns "OK" if OK button clicked
' Returns "CANCEL" if Cancel button clicked
   'Modal show of the form
   fmtTwoGroups.Show 1

   tgp_ShowForm_s = fmtTwoGroups!lblExitStatus.Caption


End Function

Function tpg_LeftListCount_i () As Integer
      tpg_LeftListCount_i = fmtTwoGroups!lstLeft.ListCount
End Function

Function tpg_RightListCount_i () As Integer

   tpg_RightListCount_i = fmtTwoGroups!lstRight.ListCount

End Function

