': WIN.BAS
'-    Misc routines for working with Windows
'
' Copyright 1994, AA-Software International
'     Distributed for non-commercial educational use only.
'     For other use contact:
'        AA-Software International
'        12 ter Domaine Du Bois Joli
'        06330 Roquefort-Les-Pins, France
'
'        Tel: (+33) 93.77.50.47
'        Fax: (+33) 93.77.19.78
'        Internet: cswilly@acm.org
'        CompuServe: 100343,2570
'
Option Explicit

Dim windowsList_h()        As Integer
Dim windowsTitles_s()      As String
Dim instanceOwnerList_h()  As Integer

Const GW_CHILD = 5
Const GW_HWNDNEXT = 2
Declare Function GetDeskTopWindow% Lib "User" ()
Declare Function GetWindow% Lib "User" (ByVal hWnd%, ByVal wCmd%)
Declare Function GetWindowTextLength% Lib "User" (ByVal hWnd%)
Declare Function GetWindowText% Lib "User" (ByVal hWnd%, ByVal lpString$, ByVal strLen%)
Declare Function GetWindowWord% Lib "User" (ByVal hWnd%, ByVal nIndex%)

Declare Function LoadIcon Lib "User" (ByVal hInstance As Integer, ByVal lpIconName As Any) As Integer
Declare Function DrawIcon Lib "User" (ByVal hDC As Integer, ByVal x As Integer, ByVal Y As Integer, ByVal hIcon As Integer) As Integer


Declare Function SendMessage Lib "user.exe" (ByVal h As Integer, ByVal m As Integer, ByVal w As Integer, l As Any) As Long

Declare Function getFocus Lib "user.exe" () As Integer
Declare Function SetFocusAPI% Lib "User" Alias "SetFocus" (ByVal hWnd%)
Declare Function ShowWindow% Lib "User" (ByVal hWnd%, ByVal nCmdShow%)
Declare Function IsWindow% Lib "User" (ByVal hWnd%)
Declare Function IsWindowVisible% Lib "User" (ByVal hWnd%)
Declare Function IsIconic% Lib "User" (ByVal hWnd%)


Const SWP_NOMOVE = 2
Const SWP_NOSIZE = 1
Const FLAGS = SWP_NOMOVE Or SWP_NOSIZE
Const HWND_TOPMOST = -1
Const HWND_NOTOPMOST = -2
Declare Function SetWindowPos Lib "user" (ByVal h%, ByVal hb%, ByVal x%, ByVal Y%, ByVal cx%, ByVal cy%, ByVal f%) As Integer

Global Const WM_USER = &H400
''  Listbox messages
Global Const LB_ADDSTRING = (WM_USER + 1)
Global Const LB_INSERTSTRING = (WM_USER + 2)
Global Const LB_DELETESTRING = (WM_USER + 3)
Global Const LB_RESETCONTENT = (WM_USER + 5)
Global Const LB_SETSEL = (WM_USER + 6)
Global Const LB_SETCURSEL = (WM_USER + 7)
Global Const LB_GETSEL = (WM_USER + 8)
Global Const LB_GETCURSEL = (WM_USER + 9)
Global Const LB_GETTEXT = (WM_USER + 10)
Global Const LB_GETTEXTLEN = (WM_USER + 11)
Global Const LB_GETCOUNT = (WM_USER + 12)
Global Const LB_SELECTSTRING = (WM_USER + 13)
Global Const LB_DIR = (WM_USER + 14)
Global Const LB_GETTOPINDEX = (WM_USER + 15)
Global Const LB_FINDSTRING = (WM_USER + 16)
Global Const LB_GETSELCOUNT = (WM_USER + 17)
Global Const LB_GETSELITEMS = (WM_USER + 18)
Global Const LB_SETTABSTOPS = (WM_USER + 19)
Global Const LB_GETHORIZONTALEXTENT = (WM_USER + 20)
Global Const LB_SETHORIZONTALEXTENT = (WM_USER + 21)
Global Const LB_SETCOLUMNWIDTH = (WM_USER + 22)
Global Const LB_SETTOPINDEX = (WM_USER + 24)
Global Const LB_GETITEMRECT = (WM_USER + 25)
Global Const LB_GETITEMDATA = (WM_USER + 26)
Global Const LB_SETITEMDATA = (WM_USER + 27)
Global Const LB_SELITEMRANGE = (WM_USER + 28)
Global Const LB_MSGMAX = (WM_USER + 33)
Global Const LB_SETCARETINDEX = (WM_USER + 31)
Global Const LB_GETCARETINDEX = (WM_USER + 32)
Global Const LB_SETITEMHEIGHT = (WM_USER + 33)
Global Const LB_GETITEMHEIGHT = (WM_USER + 34)
Global Const LB_FINDSTRINGEXACT = (WM_USER + 35)

Private Sub pGetIcon (picControl As Control, ByVal win_h As Integer)
      
      'Clear previous ICON
      picControl.Picture = LoadPicture("")

      Const GWW_HINSTANCE = (-6)
      Dim hInstance As Integer
      hInstance = GetWindowWord%(win_h, GWW_HINSTANCE)
      
      ' Iterate through icon resource identifier values
      '  until you obtain a valid handle to an icon.
      Dim hIcon As Integer
      Dim n&
      Do
         hIcon = LoadIcon(hInstance, n&)
         n& = n& + 1
      Loop Until hIcon <> 0 Or n& > 10000
      
      If n& <= 10000 Then
      Dim r As Integer
      picControl.AutoRedraw = -1 ' Make hDC point to persistent bitmap.
      Rem r = DrawIcon(picControl.hDC, 19, 19, hIcon) 'Draw the icon.
      r = DrawIcon(picControl.hDC, 1, 1, hIcon) 'Draw the icon.
      picControl.Refresh         ' Refresh from persistent bitmap to Picture.
      End If

End Sub

Sub win_DisplayWindowsTasks (ctlDisplayOutput As Control)
   
   ctlDisplayOutput.Clear

   'Get to top level window
   Dim wnd_h As Integer
   wnd_h = GetDeskTopWindow%()

   'Get first child
   wnd_h = GetWindow%(wnd_h, GW_CHILD)
   
   Dim listLen_i As Integer
   listLen_i = 0
   
   Do While wnd_h <> 0

      'Get the Windows Title
      Dim textLength_i As Integer
      textLength_i = GetWindowTextLength%(wnd_h) + 1
      Dim windowText_s As String
      windowText_s = Space(textLength_i)
      textLength_i = GetWindowText%(wnd_h, windowText_s, textLength_i)
      
      'Filter out duplicate windows
      'Get the owner of the window
      Const GWW_HINSTANCE = (-6)
      Dim instanceOwner_h As Integer
      instanceOwner_h = GetWindowWord%(wnd_h, GWW_HINSTANCE)
      'Lookup instance
      Dim i As Integer
      For i = 0 To listLen_i - 1
         If instanceOwner_h = instanceOwnerList_h(i) Then
            instanceOwner_h = 0
            Exit For
         End If
      Next i

      'Ensure Title is not null and no duplicate instances
      If textLength_i <> 0 And IsWindowVisible%(wnd_h) And instanceOwner_h <> 0 Then



         'Add window to list
         ReDim Preserve windowsList_h(listLen_i)
         windowsList_h(listLen_i) = wnd_h
         ReDim Preserve windowsTitles_s(listLen_i)
         windowsTitles_s(listLen_i) = Left$(windowText_s, textLength_i)
         ReDim Preserve instanceOwnerList_h(listLen_i)
         instanceOwnerList_h(listLen_i) = instanceOwner_h

         'Display window's title
         ctlDisplayOutput.AddItem windowsTitles_s(listLen_i)

         listLen_i = listLen_i + 1
      End If
      
      'Get next child
      wnd_h = GetWindow%(wnd_h, GW_HWNDNEXT)
   Loop

End Sub

Sub win_GetIcon (picControl As Control, ByVal winTitle_s As String)
   'find windows handel index
   Dim winIndex_i As Integer
   For winIndex_i = 0 To UBound(windowsTitles_s)
      If winTitle_s = windowsTitles_s(winIndex_i) Then Exit For
   Next winIndex_i

   'get the handel
   Dim wnd_h As Integer
   wnd_h = windowsList_h(winIndex_i)

   'Verify the handel is still good
   If IsWindow%(wnd_h) Then
      pGetIcon picControl, wnd_h
   End If

End Sub

Sub win_ListBoxAddTabItem5 (l As Control, i1 As String, i2 As String, i3 As String, i4 As String, i5 As String, i6 As String)


   Dim item_s As String

   item_s = i1

   If i2 <> "" Then item_s = item_s & Chr$(9) & i2
   If i3 <> "" Then item_s = item_s & Chr$(9) & i3
   If i4 <> "" Then item_s = item_s & Chr$(9) & i4
   If i5 <> "" Then item_s = item_s & Chr$(9) & i5
   If i6 <> "" Then item_s = item_s & Chr$(9) & i6

   l.AddItem item_s

End Sub

Sub win_ListBoxAddTabItems (l As Control, items_s() As String)

   Dim item_s As String
   item_s = items_s(0)


   Dim i As Integer
   For i = 1 To UBound(items_s)
      item_s = item_s & Chr$(9) & items_s(i)
      Next i

   l.AddItem item_s

End Sub

Sub win_ListBoxSetTabs (c As Control, tabValues() As Integer)

   Dim i As Integer
   For i = 0 To UBound(tabValues)
      tabValues(i) = tabValues(i) * 4
      If tabValues(i) = 0 Then Exit For
   Next i
   
   Dim retval As Long
   retval = SendMessage(c.hWnd, LB_SETTABSTOPS, i, tabValues(0))

End Sub

Sub win_ListBoxSetTabs5 (c As Control, t1 As Integer, t2 As Integer, t3 As Integer, t4 As Integer, t5 As Integer)

   ReDim tabValues(4) As Integer
   tabValues(0) = t1
   tabValues(1) = t2
   tabValues(2) = t3
   tabValues(3) = t4
   tabValues(4) = t5

   win_ListBoxSetTabs c, tabValues()

End Sub

Sub win_SetFocus (ByVal winTitle_s As String)

   'find windows handel index
   Dim winIndex_i As Integer
   For winIndex_i = 0 To UBound(windowsTitles_s)
      If winTitle_s = windowsTitles_s(winIndex_i) Then Exit For
   Next winIndex_i

   
   'get the handel
   Dim wnd_h As Integer
   wnd_h = windowsList_h(winIndex_i)

   'Verify the handel is still good
   If IsWindow%(wnd_h) Then
      'Set focus to selected window
      Dim previousWnd_h As Integer

      previousWnd_h = ShowWindow%(wnd_h, 9)
      previousWnd_h = SetFocusAPI%(wnd_h)
   End If

End Sub

Sub win_SetWindowNotTopMost (ByVal win_h As Integer)

   Dim retval_i As Integer
   retval_i = SetWindowPos(win_h, HWND_NOTOPMOST, 0, 0, 0, 0, FLAGS)

'Note:
'  retval_i is not check, but is non-zero if the set was successfull
End Sub

Sub win_SetWindowTopMost (ByVal win_h As Integer)

   Dim retval_i As Integer
   retval_i = SetWindowPos(win_h, HWND_TOPMOST, 0, 0, 0, 0, FLAGS)

'Note:
'  retval_i is not check, but is non-zero if the set was successfull
End Sub

