Option Explicit

Sub TabDialog (tc As Form, Items() As String, ActiveTab As Integer, ByVal XPos As Long, ByVal YPos As Long)

'***    Produces Tabbed dialog boxes aka Paradox and Word 6

'***    Forces form to be scaled on Pixels

'***    tc          Form on which to operate
'***    Items()     Array containing items for tabs dimmed to correct no entities
'***    ActiveTab   Current Active Tab passed to/from routine
'***    Xpos,YPos   of mouse pointer (0 in no click, just draw)


    Dim NoItems As Integer, ItemWidth  As Integer
    Dim c As Integer, x As Long
    Dim x1 As Long

    Const LabHeight = 18            '*** Height of labels
    Const Offset = 4                '*** Offset from top of screen
    Const HighLightCol = &HFFFFFF   '*** Colour used for highlighting
    Const LowLightCol = &H808080    '*** Colour used for lowlighting

    tc.ScaleMode = 3'*** Form must be Pixels!


    If ActiveTab = 0 Then '*** Clicked somewhere
        If YPos < Offset Or YPos > Offset + LabHeight Then '*** not in tab !
            Exit Sub                                       '*** get out
        End If
    End If

    NoItems = UBound(Items)
    ItemWidth = (tc.ScaleWidth - 2) / NoItems

    '*** Clear existing tabs drawn
    tc.Line (0, 0)-(Screen.Width - 2, LabHeight + Offset + 1), tc.BackColor, BF

    '*** Draw up initial black lines/boxing
    x = 0
    For c = 1 To NoItems
        tc.Line (x, LabHeight + Offset)-(x, 4 + Offset), 0
        tc.Line (x, 4 + Offset)-(x + 4, 0 + Offset), 0
        tc.Line (x + 4, 0 + Offset)-(x + ItemWidth - 4, 0 + Offset), 0
        tc.Line (x + ItemWidth - 4, 0 + Offset)-(x + ItemWidth, 4 + Offset), 0
        tc.Line (x + ItemWidth, 4 + Offset)-(x + ItemWidth, LabHeight + Offset + 2), 0
        x = x + ItemWidth
    Next c
    tc.Line (0, LabHeight + Offset)-(0, tc.ScaleHeight - 1), 0
    tc.Line (0, tc.ScaleHeight - 1)-((ItemWidth * NoItems), tc.ScaleHeight - 1), 0
    tc.Line ((ItemWidth * NoItems), tc.ScaleHeight - 1)-((ItemWidth * NoItems), LabHeight + Offset), 0
    
    '*** Draw 3D bit around main form
    tc.Line (1, LabHeight + Offset)-(1, tc.ScaleHeight - 1), HighLightCol
    tc.Line (2, LabHeight + Offset)-(2, tc.ScaleHeight - 1), HighLightCol
    tc.Line (2, tc.ScaleHeight - 2)-((ItemWidth * NoItems) - 1, tc.ScaleHeight - 2), LowLightCol
    tc.Line (3, tc.ScaleHeight - 3)-((ItemWidth * NoItems) - 2, tc.ScaleHeight - 3), LowLightCol
    tc.Line ((ItemWidth * NoItems) - 1, tc.ScaleHeight - 2)-((ItemWidth * NoItems) - 1, LabHeight + Offset), LowLightCol
    tc.Line ((ItemWidth * NoItems) - 2, tc.ScaleHeight - 2)-((ItemWidth * NoItems) - 2, LabHeight + Offset), LowLightCol
    
    If XPos <> 0 Then               '***  Clicked on tab somewhere, work-out where
        ActiveTab = Int(XPos / ItemWidth) + 1
    End If

    If ActiveTab = 0 Then           '*** Just in case make sure one is active
        ActiveTab = 1
    End If

    '*** Draw 3D bit around Active Tab
    x = (ActiveTab - 1) * ItemWidth
    tc.Line (x + 1, LabHeight + Offset)-(x + 1, 4 + Offset), HighLightCol
    tc.Line (x + 1, 4 + Offset)-(x + 4, 1 + 0 + Offset), HighLightCol
    tc.Line (x + 2, LabHeight + Offset)-(x + 2, 4 + Offset), HighLightCol
    tc.Line (x + 2, 4 + Offset)-(x + 5, 1 + 0 + Offset), HighLightCol
    tc.Line (x + 4, 1 + 0 + Offset)-(x + ItemWidth - 4, 1 + 0 + Offset), HighLightCol
    tc.Line (x + ItemWidth - 4, 1 + 0 + Offset)-(x + ItemWidth - 1, 4 + Offset), LowLightCol
    tc.Line (x + ItemWidth - 1, 4 + Offset)-(x + ItemWidth - 1, LabHeight + Offset + 2), LowLightCol
    tc.Line (x + ItemWidth - 5, 1 + 0 + Offset)-(x + ItemWidth - 2, 4 + Offset), LowLightCol
    tc.Line (x + ItemWidth - 2, 4 + Offset)-(x + ItemWidth - 2, LabHeight + Offset + 2), LowLightCol

    '*** Draw 3D Horz line to the left of active tab
    x = 2
    x1 = ((ActiveTab - 1) * ItemWidth) + 1
    If x <> x1 + 1 Then
        tc.Line (x - 1, LabHeight + Offset)-(x1, LabHeight + Offset), 0
        tc.Line (x, LabHeight + Offset + 1)-(x1 + 1, LabHeight + Offset + 1), HighLightCol
    End If
    '*** Draw 3D Horz line to the right of active tab
    x = ActiveTab * ItemWidth
    x1 = (ItemWidth * NoItems) - 2
    If x <> x1 + 2 Then
        tc.Line (x, LabHeight + Offset)-(x1 + 1, LabHeight + Offset), 0
        tc.Line (x - 1, LabHeight + Offset + 1)-(x1, LabHeight + Offset + 1), HighLightCol
    End If
    
    '*** Put Text on tabs
    x = 0
    tc.CurrentY = Offset + ((LabHeight / 2) - (tc.TextHeight("X") / 2))
    For c = 1 To NoItems
        If c = ActiveTab Then
            tc.FontBold = True
        Else
            tc.FontBold = False
        End If
        tc.CurrentX = x + (ItemWidth / 2) - (tc.TextWidth(Trim(Items(c))) / 2)
        tc.Print Trim(Items(c));
        x = x + ItemWidth
    Next c
End Sub

