/*
   ****************************************************************************
   Module:  tooldemo.c
   Author:  Ray Donahue
   Date:    1/8/92 (initial writing complete)

   Purpose: This is the main module which demonstrates the functions contained
            in "toolwnd.dll".
   ****************************************************************************
*/

#include "windows.h"
#include "tooldemo.h"
#include "toolwnd.h"

HANDLE hInst;
static HWND hMainWindow;
static HWND hToolBox,hToolBar;
static BOOL fToolbox,fToolbar;
static BOOL fToolsEnabled;
static HMENU hMainMenu;
static BOOL fHzScroll,fVtScroll;
static WORD wVertPos,wHorzPos;
static char szOutput[]="This line of text is controlled by the alignment menu or tools.";


static void ToggleMenuItems(HMENU,WORD,WORD,WORD);

/* Initialize TOOINFO structure for toolbox */
static TOOLINFO tBox[16]=
{
   /* wId,dwStyle,wState,rc */
   IDM_POINTER,0,0,{0,0,0,0},
   IDM_COMBOBX,0,0,{0,0,0,0},
   IDM_CHECKBX,0,0,{0,0,0,0},
   IDM_EDITCTL,0,0,{0,0,0,0},
   IDM_PICTCTL,0,0,{0,0,0,0},
   IDM_PUSHBTN,0,0,{0,0,0,0},
   IDM_STATIC,0,0,{0,0,0,0},
   IDM_TIMER,0,0,{0,0,0,0},
   IDM_GROUPBX,0,0,{0,0,0,0},
   IDM_LISTBOX,0,0,{0,0,0,0},
   IDM_RADIOBTN,0,0,{0,0,0,0},
   IDM_HORZSCRL,0,0,{0,0,0,0},
   IDM_VERTSCRL,0,0,{0,0,0,0},
   IDM_DIRBOX,0,0,{0,0,0,0},
   IDM_DRIVEBOX,0,0,{0,0,0,0},
   IDM_FILEBOX,0,0,{0,0,0,0}
};

/* Initialize TOOLINFO structure for toolbar */
static TOOLINFO tBar[13]=
{
   /* wId,dwStyle,wState,rc */
   IDM_LARROW,WS_GROUP,0,{0,0,0,0},
   IDM_RARROW,0,0,{0,0,0,0},
   IDM_DARROW,0,0,{0,0,0,0},
   IDM_UARROW,0,0,{0,0,0,0},
   IDM_HLTEXT,WS_GROUP,0,{0,0,0,0},
   IDM_HCTEXT,0,0,{0,0,0,0},
   IDM_HRTEXT,0,0,{0,0,0,0},
   IDM_VTTEXT,WS_GROUP,0,{0,0,0,0},
   IDM_VCTEXT,0,0,{0,0,0,0},
   IDM_VBTEXT,0,0,{0,0,0,0},
   IDM_VIEW_H,WS_GROUP,0,{0,0,0,0},
   IDM_VIEW_V,0,0,{0,0,0,0},
   IDM_ABOUT,WS_GROUP,0,{0,0,0,0}
};

/*
   ****************************************************************************
   WinMain()
   The entry point for Windows.
   ****************************************************************************
*/

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
   MSG msg;

   if (!hPrevInstance)
      if (!InitApplication(hInstance))       /* Initialize shared things */
         return (FALSE);                     /* Exits if unable to initialize */

   /* Perform initializations that apply to a specific instance */

   if (!InitInstance(hInstance, nCmdShow))
      return (FALSE);

   /* Acquire and dispatch messages until a WM_QUIT message is received. */

   while (GetMessage(&msg,NULL,NULL,NULL))
   {
      TranslateMessage(&msg);                /* Translates virtual key codes */
      DispatchMessage(&msg);                 /* Dispatches message to window */
   }
   return (msg.wParam);
}

/*
   ****************************************************************************
   InitApplication()
   Initializes window data and registers window classes.
   ****************************************************************************
*/

BOOL InitApplication(hInstance)
HANDLE hInstance;
{
   WNDCLASS  wc;

   /* Fill in window class structure with parameters that describe the */
   /* main window. */

   wc.style = CS_BYTEALIGNWINDOW;
   wc.lpfnWndProc = MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(hInstance,"tools");
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW+1; 
   wc.lpszMenuName =  "ToolDemoMenu";
   wc.lpszClassName = "ToolDemoClass";

   /* Register the window class and return success/failure code. */
   return(RegisterClass(&wc));
}

/*
   ****************************************************************************
   InitInstance()
   Saves instance handle and creates main window.
   ****************************************************************************
*/

BOOL InitInstance(hInstance, nCmdShow)
HANDLE          hInstance;
int             nCmdShow;
{
   HWND hWnd;
   HBITMAP hBitmap;
   RECT rc;
   HDC hdc;
   BOOL fColor;

   /* Save the instance handle in static variable, which will be used in  */
   /* many subsequence calls from this application to Windows. */

   hInst = hInstance;

   /* Create a main window for this application instance.  */

   hWnd = CreateWindow("ToolDemoClass","ToolDemo",
      WS_OVERLAPPEDWINDOW|WS_CLIPCHILDREN|WS_VSCROLL|WS_HSCROLL,0,0,
      GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN),
      NULL,NULL,hInstance,NULL);

   /* If window could not be created, return "failure" */

   if (!hWnd)
      return (FALSE);

   hMainWindow = hWnd;                       /* Save main window handle */

   hMainMenu = GetMenu(hMainWindow);

   /* Determine if we are running monochrome and set flag appropriately */ 
   hdc = GetDC(hMainWindow);
   fColor = (GetDeviceCaps(hdc,NUMCOLORS) > 2);
   ReleaseDC(hMainWindow,hdc);
                                                                       
   /* Load the appropriate bitmap for the toolbar */
   if (fColor)
      hBitmap = LoadBitmap(hInst,MAKEINTRESOURCE(2));
   else
      hBitmap = LoadBitmap(hInst,MAKEINTRESOURCE(4));
                                                    
   /* Create toolbar (initially visible) */
   hToolBar = CreateToolbar(hMainWindow,hBitmap,13,TRUE,(LPTOOLINFO)tBar);
   if (!hToolBar)
      MessageBox(hWnd,"Unable to create tool bar.",NULL,MB_OK);

   GetClientRect(hToolBar,&rc);
                       
   /* Load the appropriate bitmap for the toolbox */ 
   if (fColor)
      hBitmap = LoadBitmap(hInst,MAKEINTRESOURCE(1));
   else
      hBitmap = LoadBitmap(hInst,MAKEINTRESOURCE(3));
                                                 
   /* Create the toolbox (initially visible) */
   hToolBox = CreateToolbox(hMainWindow,hBitmap,16,10,rc.bottom+5,2,8,TRUE,
      (LPTOOLINFO)tBox);
   if (!hToolBox)
      MessageBox(hWnd,"Unable to create tool box.",NULL,MB_OK);

   /* Set global flags, initialize menu items and tools */
   fToolbox = fToolbar = fHzScroll = fVtScroll = TRUE;
   fToolsEnabled = TRUE;
   CheckMenuItem(hMainMenu,IDM_VIEW_TOOLBOX,MF_CHECKED);
   CheckMenuItem(hMainMenu,IDM_VIEW_TOOLBAR,MF_CHECKED);
   CheckMenuItem(hMainMenu,IDM_VIEW_H,MF_CHECKED);
   CheckTool(hToolBar,IDM_VIEW_H,fHzScroll);
   CheckMenuItem(hMainMenu,IDM_VIEW_V,MF_CHECKED);
   CheckTool(hToolBar,IDM_VIEW_V,fVtScroll);
   CheckMenuItem(hMainMenu,IDM_HCTEXT,MF_CHECKED);
   CheckTool(hToolBar,IDM_HCTEXT,TRUE);
   wHorzPos = DT_CENTER;
   CheckMenuItem(hMainMenu,IDM_VBTEXT,MF_CHECKED);
   CheckTool(hToolBar,IDM_VBTEXT,TRUE);
   wVertPos = DT_BOTTOM;

   /* Make the window visible; update its client area; and return "success" */
   ShowWindow(hMainWindow,nCmdShow);
   UpdateWindow(hMainWindow);
   return (TRUE);
}

/*
   ****************************************************************************
   MainWndProc()
   Handles all messages to the main window.
   ****************************************************************************
*/

long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{
   WORD wId;
   RECT rcMain,rcTool;
   PAINTSTRUCT ps;
   int nBar;
   int cur_pos,max_pos,min_pos,new_pos;
   

   switch (message)
   {
      case WM_PAINT:
         /* Draw text based on positions selected */
         BeginPaint(hWnd,&ps);
         GetClientRect(hWnd,&rcMain);
         GetClientRect(hToolBar,&rcTool);
         rcMain.left += 5;
         rcMain.top += rcTool.bottom + 5;
         rcMain.bottom -= 5;
         rcMain.right -= 5;
         DrawText(ps.hdc,(LPSTR)szOutput,lstrlen(szOutput),&rcMain,
            wVertPos|wHorzPos|DT_SINGLELINE|DT_NOCLIP);
         EndPaint(hWnd,&ps);
         break;

      case WM_HSCROLL:
      case WM_VSCROLL:
         /* Update scroll bar positions */
         nBar = (message == WM_HSCROLL) ? SB_HORZ : SB_VERT;
         GetScrollRange(hWnd,nBar,&min_pos,&max_pos);
         cur_pos = GetScrollPos(hWnd,nBar);
         new_pos = cur_pos;
         if (wParam == SB_LINEUP)
            new_pos -= 1;
         else if(wParam == SB_LINEDOWN)
            new_pos += 1;
         new_pos = max(min_pos,new_pos);
         new_pos = min(max_pos,new_pos);
         if (new_pos != cur_pos)
            SetScrollPos(hWnd,nBar,new_pos,TRUE);
         break;

      case WM_COMMAND:
         switch (wParam)
         {
            case IDM_VIEW_README:            /* View readme.txt file */
               WinExec("notepad readme.txt",SW_SHOWMAXIMIZED);
               break;

            case IDM_EXIT:                   /* Close application */
               SendMessage(hWnd,WM_CLOSE,0,0L);
               break;

            case IDM_VIEW_TOOLBOX:
               /* Toggle the view toolbox menu item and show or hide the */
               /* toolbox window as is appropriate */
               CheckMenuItem(hMainMenu,wParam,fToolbox ? MF_UNCHECKED : MF_CHECKED);
               fToolbox = !fToolbox;
               EnableMenuItem(hMainMenu,IDM_TBX_STATUS,fToolbox ? MF_ENABLED : MF_GRAYED);
               ShowWindow(hToolBox,fToolbox ? SW_RESTORE : SW_HIDE);
               break;

            case IDM_VIEW_TOOLBAR:
               /* Toggle the view toolbar menu item and show or hide the */
               /* toolbar window as is appropriate */
               CheckMenuItem(hMainMenu,wParam,fToolbar ? MF_UNCHECKED : MF_CHECKED);
               fToolbar = !fToolbar;
               ShowWindow(hToolBar,fToolbar ? SW_RESTORE : SW_HIDE);
               break;

            case IDM_TBX_STATUS:             /* Demo disabling of toolbox */
               fToolsEnabled = !fToolsEnabled;
               ModifyMenu(hMainMenu,IDM_TBX_STATUS,MF_BYCOMMAND|MF_STRING,IDM_TBX_STATUS,
                  fToolsEnabled ? (LPSTR)"Disable Toolbox Tools" : (LPSTR)"Enable Tools");
               for (wId = IDM_POINTER; wId <= IDM_FILEBOX; wId++)
                  EnableTool(hToolBox,wId,fToolsEnabled);
               break;

            case IDM_POINTER:
            case IDM_COMBOBX:
            case IDM_CHECKBX:
            case IDM_EDITCTL:
            case IDM_PICTCTL:
            case IDM_PUSHBTN:
            case IDM_STATIC:
            case IDM_TIMER:
            case IDM_GROUPBX:
            case IDM_LISTBOX:
            case IDM_RADIOBTN:
            case IDM_HORZSCRL:
            case IDM_VERTSCRL:
            case IDM_DIRBOX:
            case IDM_DRIVEBOX:
            case IDM_FILEBOX:
               ToggleMenuItems(hMainMenu,IDM_POINTER,IDM_FILEBOX,wParam);
               /* If tool is not already selected on the toolbox window, */
               /* call function to select it */
               if (IsToolSelected(hToolBox,wParam) == FALSE)
                  ToggleTools(hToolBox,IDM_POINTER,IDM_FILEBOX,wParam);
               break;

            case IDM_LARROW:
               SendMessage(hWnd,WM_HSCROLL,SB_LINEUP,0L);
               break;

            case IDM_RARROW:
               SendMessage(hWnd,WM_HSCROLL,SB_LINEDOWN,0L);
               break;

            case IDM_DARROW:
               SendMessage(hWnd,WM_VSCROLL,SB_LINEUP,0L);  
               break;

            case IDM_UARROW:
               SendMessage(hWnd,WM_VSCROLL,SB_LINEDOWN,0L);
               break;

            case IDM_HLTEXT:
            case IDM_HCTEXT:
            case IDM_HRTEXT:
               ToggleMenuItems(hMainMenu,IDM_HLTEXT,IDM_HRTEXT,wParam);
               ToggleTools(hToolBar,IDM_HLTEXT,IDM_HRTEXT,wParam);
               if (wParam == IDM_HLTEXT)
                  wHorzPos = DT_LEFT;
               else if (wParam == IDM_HCTEXT)
                  wHorzPos = DT_CENTER;
               else
                  wHorzPos = DT_RIGHT;
               InvalidateRect(hWnd,NULL,TRUE);
               UpdateWindow(hWnd);
               break;

            case IDM_VTTEXT:
            case IDM_VCTEXT:
            case IDM_VBTEXT:
               ToggleMenuItems(hMainMenu,IDM_VTTEXT,IDM_VBTEXT,wParam);
               ToggleTools(hToolBar,IDM_VTTEXT,IDM_VBTEXT,wParam);
               if (wParam == IDM_VTTEXT)
                  wVertPos = DT_TOP;
               else if (wParam == IDM_VCTEXT)
                  wVertPos = DT_VCENTER;
               else
                  wVertPos = DT_BOTTOM;
               InvalidateRect(hWnd,NULL,TRUE);
               UpdateWindow(hWnd);
               break;

            case IDM_VIEW_H:
               fHzScroll = !fHzScroll;
               CheckTool(hToolBar,IDM_VIEW_H,fHzScroll);
               CheckMenuItem(hMainMenu,IDM_VIEW_H,fHzScroll ? MF_CHECKED : MF_UNCHECKED);
               ShowScrollBar(hWnd,SB_HORZ,fHzScroll);
               EnableTool(hToolBar,IDM_LARROW,fHzScroll);
               EnableTool(hToolBar,IDM_RARROW,fHzScroll);
               break;

            case IDM_VIEW_V:
               fVtScroll = !fVtScroll;
               CheckTool(hToolBar,IDM_VIEW_V,fVtScroll);
               CheckTool(hToolBar,IDM_VIEW_V,fVtScroll);
               CheckMenuItem(hMainMenu,IDM_VIEW_V,fVtScroll ? MF_CHECKED : MF_UNCHECKED);
               ShowScrollBar(hWnd,SB_VERT,fVtScroll);
               EnableTool(hToolBar,IDM_UARROW,fVtScroll);
               EnableTool(hToolBar,IDM_DARROW,fVtScroll);
               break;

            case IDM_HLP_INDEX:
            case IDM_HLP_KBD:
            case IDM_HLP_CMD:
            case IDM_HLP_PROC:
            case IDM_HLP_USE:
               MessageBox(hWnd,"Help not implemented!","Demo",MB_OK);
               break;

            case IDM_ABOUT:
               /* This function is contained in the demo version of the DLL */
               AboutToolWnd(hWnd);
               break;

            default:
               break;
         }
         break;

      case TM_TBXCLOSED:                   /* Close from toolbox system menu */
        CheckMenuItem(hMainMenu,IDM_VIEW_TOOLBOX,MF_UNCHECKED);
        fToolbox = FALSE;
        EnableMenuItem(hMainMenu,IDM_TBX_STATUS,MF_GRAYED);
        break;


      case WM_DESTROY:
         PostQuitMessage(0);
         break;

      default:
         return (DefWindowProc(hWnd, message, wParam, lParam));
   }
   return (NULL);
}

/*
   ****************************************************************************
   ToggleMenuItems()
   Toggles the selection of the control menu.  This function works very similar
   to the CheckRadioButton function for radio buttons.
   ****************************************************************************
*/

void ToggleMenuItems(HMENU hMenu,WORD wFirst,WORD wLast,WORD wCurrent)
{
   WORD wCnt;

   for (wCnt=wFirst; wCnt <= wLast; wCnt++)
   {
      if (GetMenuState(hMenu,wCnt,MF_BYCOMMAND) & MF_CHECKED)
      {
         if (wCnt == wCurrent)
            return;
         CheckMenuItem(hMenu,wCnt,MF_BYCOMMAND|MF_UNCHECKED);
      }
   }
   CheckMenuItem(hMenu,wCurrent,MF_BYCOMMAND|MF_CHECKED);
}
