/************************************************************************
TXTHOOK.DLL -- Author: Jeff Simms -- CIS 72200,3173 --	September 7, 1992

Purpose - Subclass VB textbox to add 'ES_NOHIDESEL' functionality. Also
adds caret choice and overstrike mode.

Modesty prevents me from taking full credit for this code. But hopefully
this is cut and paste at its best.
***********************************************************************/

#include <windows.h>
#include "txthook.h"

int gOverwrite=0,nWidth;
HBITMAP ghBitmap=0;
HFONT hfont,tmpfont;
POINT  lppt;
TEXTMETRIC tm;
HDC hdc;
FARPROC  lpfnVBEditWndProc;
HWND hVBEditWnd=0,hVBFormWnd,wnd;
WORD wFlag=0,wStart,wEnd;
DWORD dwResult;

int FAR PASCAL WEP (int bSystemExit)
{
    return (1);
}

VOID __export FAR PASCAL SetTextHook(HWND hVBTextWnd,HWND hvbFormWnd)
{
    if (hVBEditWnd)
	   return;

    hVBEditWnd = hVBTextWnd;
    hVBFormWnd = hvbFormWnd;
    GetCaretPos(&lppt);
    NewFont();

    lpfnVBEditWndProc = (FARPROC) SetWindowLong(hVBEditWnd,GWL_WNDPROC,
			     (DWORD)(FARPROC) MainFilterProc);
    SetFocus(hVBEditWnd);
}

VOID __export FAR PASCAL TextOverstrike(int bSwitch)
{
       gOverwrite = bSwitch;
	if (GetFocus() == hVBEditWnd){
	    DestroyCaret();
	    DoTheCaretThing();
	}
	else
	    SetFocus(hVBEditWnd);
}

VOID __export FAR PASCAL CaretBitmap(HBITMAP hbitmap)
{
    if (ghBitmap != hbitmap)
	DeleteObject(ghBitmap);

	ghBitmap = hbitmap;
	if (GetFocus() == hVBEditWnd){
	    DestroyCaret();
	    DoTheCaretThing();
	}
	else
	    SetFocus(hVBEditWnd);
}

VOID FAR PASCAL DoTheCaretThing()
{

	   if (hfont != (HFONT) SendMessage(hVBEditWnd,WM_GETFONT,0,0L))
		NewFont();

	    if (!gOverwrite)
	    nWidth = GetSystemMetrics(SM_CXBORDER)*2;
	    else
	    nWidth = tm.tmAveCharWidth;
	    CreateCaret(hVBEditWnd,ghBitmap,nWidth,tm.tmHeight);
	    if (!wFlag)
	    SetCaretPos(lppt.x,lppt.y);
	    else
	    wFlag = 0;
	    ShowCaret(hVBEditWnd);

}


VOID FAR PASCAL NewFont()
{
    tmpfont = (HFONT) SendMessage(hVBFormWnd,WM_GETFONT,0,0L);
    hfont = (HFONT) SendMessage(hVBEditWnd,WM_GETFONT,0,0L);
    SendMessage(hVBFormWnd,WM_SETFONT,(WORD) hfont,0L);
    hdc = GetDC(hVBFormWnd);
    GetTextMetrics(hdc,&tm);
    ReleaseDC(hVBFormWnd,hdc);
    SendMessage(hVBFormWnd,WM_SETFONT,(WORD) tmpfont,0L);
}

VOID __export FAR PASCAL UndoTextHook(int zero)
{
    SetWindowLong(hVBEditWnd,GWL_WNDPROC, (DWORD)(FARPROC) lpfnVBEditWndProc);
    hVBEditWnd = 0;
    gOverwrite = 0;
    DeleteObject(ghBitmap);
    ghBitmap = 0;
}

LONG __export FAR PASCAL MainFilterProc(HWND hWnd,unsigned wMsg,WORD wParam,LONG lParam)
{

      switch (wMsg){

	case WM_CHAR:
	    if (gOverwrite && (wParam != VK_BACK) && (wParam != VK_DELETE))
	    {
		dwResult = SendMessage(hVBEditWnd,EM_GETSEL,0,0L);
                wStart   = LOWORD(dwResult);
                wEnd     = HIWORD(dwResult);

                if (wEnd == wStart)
                {
                   wEnd++;
		   SendMessage(hVBEditWnd,EM_SETSEL,0,MAKELONG(wStart,wEnd));
                }
		SendMessage(hVBEditWnd,EM_REPLACESEL,0,(DWORD)((LPSTR)&wParam ));
                return (FALSE);
            }
            break;

	 case WM_LBUTTONDOWN:
	    wFlag = 1;
	    SetFocus(hVBEditWnd);
	    break;

	 case WM_SETFOCUS:
	    DoTheCaretThing();
	    break;

	case  WM_KILLFOCUS:
	    GetCaretPos(&lppt);
	    DestroyCaret();
	    return 0L;
	    break;

	case  WM_DESTROY:
	    DeleteObject(ghBitmap);
	    SetWindowLong(hVBEditWnd,GWL_WNDPROC, (DWORD)(FARPROC) lpfnVBEditWndProc);
	    PostMessage(hVBEditWnd,WM_DESTROY,0,0);
	    return 0L;
	    break;
      }
  return(CallWindowProc(lpfnVBEditWndProc,hWnd, wMsg, wParam, lParam));
}
