#include <windows.h>
#include <vbapi.h>  
#include "vbrc.h"
#include "vbfrm.h"


#define MODEL_FLAGS		( MODEL_fInitMsg | MODEL_fLoadMsg | MODEL_fInvisAtRun )

MODEL modelVBForm =
{
    VB_VERSION, 							// VB version being used
    MODEL_FLAGS,							// MODEL flags
    (PCTLPROC)VBFormCtlProc,				// Control procedures
    CS_VREDRAW | CS_HREDRAW,				// Class style
    WS_CHILD | WS_BORDER,					// Default Windows style
    sizeof(VBFORM),							// Size of PIX structure
    IDBMP_VBFORM_UP, 						// Palette bitmap ID
    "FormFx",								// Default control name
    "FormFx",								// Visual Basic class name
    NULL,									// Parent class name
    VBForm_Properties,						// Property information table
    NULL        							// Event information table
};


//---------------------------------------------------------------------------
// Global Variables
//---------------------------------------------------------------------------
BOOL bDevTimeInit = FALSE;
HANDLE hModDLL;
WORD cVBXusers = 0;
BOOL bFrmSubclassed = FALSE;
WNDPROC	lpvbFrmProc;

void Draw3DRB (HDC hDC, int nWidth, LPRECT lprc, LONG clrref)
{
  HPEN hOldPen, hColorPen;
  
    hColorPen = CreatePen(PS_SOLID, nWidth, clrref);
	hOldPen = SelectObject (hDC, hColorPen);
	MoveTo (hDC, lprc->left, lprc->bottom);
	LineTo (hDC, lprc->right, lprc->bottom); 
	LineTo (hDC, lprc->right, lprc->top);
	SelectObject (hDC, hOldPen);   
	DeleteObject (hColorPen);
}

void Draw3DLT (HDC hDC,int nWidth, LPRECT lprc, LONG clrref)
{
                  
  HPEN hOldPen, hColorPen;
 	
	hColorPen = CreatePen(PS_SOLID, nWidth, clrref);
	hOldPen = SelectObject (hDC, hColorPen);
	MoveTo (hDC, lprc->right, lprc->top);
	LineTo (hDC, lprc->left, lprc->top); 
	LineTo (hDC, lprc->left , lprc->bottom);	  	        
	SelectObject (hDC, hOldPen);   
	DeleteObject (hColorPen);
}

LONG FAR PASCAL _export NewFrmProc
(
HWND hWnd, 
USHORT msg, 
USHORT wp, 
LONG lp
)
{
                 
  
                   
	switch (msg)
	{
		case WM_NCACTIVATE:
			PostMessage (hWnd, WM_NCPAINT, 0, 0L);
			break;

		case WM_NCPAINT:  
		if ((GetWindowLong(hWnd, GWL_STYLE) & WS_THICKFRAME) && !IsIconic(hWnd))
		{
			HDC hDC;                                           
			RECT	rc;            
			
			    
			    CallWindowProc (lpvbFrmProc, hWnd, msg , wp ,lp);
			    
			    GetWindowRect(hWnd, &rc);
			    ScreenToClient(hWnd, (LPPOINT)&rc);
			    ScreenToClient(hWnd, (LPPOINT)&rc.right); 
			    hDC = GetWindowDC (hWnd ) ;
			    SetViewportOrg( hDC, -rc.left, -rc.top );
			    SetViewportExt (hDC, rc.right - rc.left, rc.bottom -rc.top );
				
				InflateRect(&rc, -1, -1);
				Draw3DLT (hDC, 2, &rc, RGB(128,128,128));
				Draw3DRB (hDC, 2, &rc, RGB(0,0,0));
	  	        InflateRect(&rc, -2, -2);
	  	        Draw3DLT (hDC, 1, &rc, RGB(192,192,192));
	  	        rc.left --;
	  	        rc.top --;
	  	        Draw3DLT (hDC, 1, &rc, RGB(255,255,255));
	  	        rc.left ++;
	  	        rc.top ++;
	  	        Draw3DRB (hDC, 2, &rc, RGB(128,128,128));
	  	        
				if ((GetWindowLong(hWnd, GWL_STYLE) &
						(WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX)))
	  	  {
	  	        rc.bottom = rc.top + GetSystemMetrics (SM_CYCAPTION);
	  	        InflateRect(&rc, -1, -1);
	  	        Draw3DLT (hDC, 1, &rc, RGB(128,128,128));
	  	        Draw3DRB (hDC, 1, &rc, RGB(255,255,255));
				}
	  	        ReleaseDC(hWnd, hDC);
	  	        return 0;
		}   
		break;
		
		case WM_ERASEBKGND:
			{
			 	HBRUSH	hBr;
	  			RECT	rc;
	 
	            hBr = CreateSolidBrush(RGB(192,192,192));
      			GetClientRect(hWnd, &rc);
	  	        FillRect ( (HDC)wp, &rc, hBr ); 
	  	        DeleteObject (hBr);
	  	        
	  	        return TRUE;
			}
			
	}

	return CallWindowProc (lpvbFrmProc, hWnd, msg , wp ,lp);
}

/****************************************************************************
 *
 *  FUNCTION:  VbFormCtlProc(HCTL, HWND, USHORT, USHORT, LONG)
 *
 *  PURPOSE:   This routine is the subclassed window procedure.  Visual Basic
 *             passes VBM_, VBN_, and WM_ messages to this routine.
 *             The custom control determines which messages to process.
 *             Any messages that are not processed need to passed on to the
 *             default message processing routine VBDefControlProc().
 *
 ******************************************************************************/

LONG FAR PASCAL _export VbFormCtlProc(HCTL hctl, HWND hwnd, USHORT msg,
			USHORT wp, LONG lp)
{
  WNDPROC   lpTemp;

    switch (msg) 
      {
       

        case WM_CREATE:
				lpTemp = GetWindowLong (GetParent(hwnd), GWL_WNDPROC);
			 if (!bFrmSubclassed && (VBGetMode() == MODE_RUN))
			 {
		 		lpvbFrmProc = (WNDPROC)GetClassLong (GetParent(hwnd), GCL_WNDPROC);
		 		// For the Whole Class
				SetClassLong (GetParent(hwnd), GCL_WNDPROC, (LONG)NewFrmProc );
		 		
				// For this form
		 		SetWindowLong (GetParent(hwnd), GWL_WNDPROC, (LONG)NewFrmProc);

		 		RedrawWindow (GetParent(hwnd), NULL, NULL, RDW_INVALIDATE); 
		 		bFrmSubclassed = TRUE; 
			 }
			
			break; 
		
		case WM_DESTROY:
		if ((cVBXusers == 1) && bFrmSubclassed)
		{
			SetClassLong (GetParent(hwnd), GCL_WNDPROC, (LONG)lpvbFrmProc );			
			SetWindowLong (GetParent(hwnd), GWL_WNDPROC, (LONG)lpvbFrmProc);
	 		RedrawWindow (GetParent(hwnd), NULL, NULL, RDW_INVALIDATE); 
			bFrmSubclassed = FALSE;
		}
     }
    return VBDefControlProc(hctl, hwnd, msg, wp, lp);
}



/****************************************************************************
 *
 *  FUNCTION:  LibMain(HANDLE, WORD, WORD, LPSTR)
 *
 *  PURPOSE:   Initialize library. This routine is called when the
 *             first client loads the DLL.
 *
 ******************************************************************************/

int FAR PASCAL LibMain
(
HANDLE hModule, 
WORD wDataSeg, 
WORD cbHeapSize,
LPSTR  lpszCmdLine
)
{
    // Avoid warnings on unused (but required) formal parameters
    wDataSeg	= wDataSeg;
    cbHeapSize	= cbHeapSize;
    lpszCmdLine = lpszCmdLine;

    hModDLL = hModule;

    return 1;
}


/****************************************************************************
 *
 *  FUNCTION:  VBINITCC(USHORT, BOOL)
 *
 *  PURPOSE:   Register custom control.  This routine is called by Visual Basic
 *             or the Visual Basic emulation layer when the custom control DLL
 *             is loaded for use.
 *
 ******************************************************************************/

BOOL FAR PASCAL _export VBINITCC
(
USHORT usVersion, 
BOOL fRuntime
)
{
   ++cVBXusers;

   	// Register control(s)
    return VBRegisterModel(hModDLL, &modelVBForm);
}

//---------------------------------------------------------------------------
// Unregister custom control.  This routine is called by Visual Basic when
// the custom control DLL (VBX) is being unloaded.
//---------------------------------------------------------------------------
VOID FAR PASCAL _export VBTERMCC(VOID)
{
    --cVBXusers;
}

//---------------------------------------------------------------------------

