Option Explicit

Global Const WM_DRAWITEM = &H2B
Global Const WM_MEASUREITEM = &H2C

'   Ternary raster operations
Global Const SRCCOPY = &HCC0020 ' (DWORD) dest = source
Global Const SRCPAINT = &HEE0086    ' (DWORD) dest = source OR dest
Global Const SRCAND = &H8800C6  ' (DWORD) dest = source AND dest
Global Const SRCINVERT = &H660046   ' (DWORD) dest = source XOR dest
Global Const SRCERASE = &H440328    ' (DWORD) dest = source AND (NOT dest )
Global Const NOTSRCCOPY = &H330008  ' (DWORD) dest = (NOT source)
Global Const NOTSRCERASE = &H1100A6 ' (DWORD) dest = (NOT src) AND (NOT dest)
Global Const MERGECOPY = &HC000CA   ' (DWORD) dest = (source AND pattern)
Global Const MERGEPAINT = &HBB0226  ' (DWORD) dest = (NOT source) OR dest
Global Const PATCOPY = &HF00021 ' (DWORD) dest = pattern
Global Const PATPAINT = &HFB0A09    ' (DWORD) dest = DPSnoo
Global Const PATINVERT = &H5A0049   ' (DWORD) dest = pattern XOR dest
Global Const DSTINVERT = &H550009   ' (DWORD) dest = (NOT dest)
Global Const BLACKNESS = &H42&  ' (DWORD) dest = BLACK
Global Const WHITENESS = &HFF0062   ' (DWORD) dest = WHITE

'  StretchBlt() Modes
Global Const BLACKONWHITE = 1
Global Const WHITEONBLACK = 2
Global Const COLORONCOLOR = 3

'  PolyFill() Modes
Global Const ALTERNATE = 1
Global Const WINDING = 2

' SetAttr, Dir, GetAttr functions
Global Const ATTR_NORMAL = 0
Global Const ATTR_READONLY = 1
Global Const ATTR_HIDDEN = 2
Global Const ATTR_SYSTEM = 4
Global Const ATTR_VOLUME = 8
Global Const ATTR_DIRECTORY = 16
Global Const ATTR_ARCHIVE = 32

'  DrawText() Format Flags
Global Const DT_TOP = &H0
Global Const DT_LEFT = &H0
Global Const DT_CENTER = &H1
Global Const DT_RIGHT = &H2
Global Const DT_VCENTER = &H4
Global Const DT_BOTTOM = &H8
Global Const DT_WORDBREAK = &H10
Global Const DT_SINGLELINE = &H20
Global Const DT_EXPANDTABS = &H40
Global Const DT_TABSTOP = &H80
Global Const DT_NOCLIP = &H100
Global Const DT_EXTERNALLEADING = &H200
Global Const DT_CALCRECT = &H400
Global Const DT_NOPREFIX = &H800
Global Const DT_INTERNAL = &H1000

Type RECT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

Type MEASUREITEMSTRUCT
    CtlType As Integer
    CtlID As Integer
    itemID As Integer
    itemWidth As Integer
    itemHeight As Integer
    itemData As Long
End Type

Type DRAWITEMSTRUCT
    CtlType As Integer
    CtlID As Integer
    itemID As Integer
    itemAction As Integer
    itemState As Integer
    hwndItem As Integer
    hDC As Integer
    rcItem As RECT
    itemData As Long
End Type

'  Listbox Styles
Global Const LBS_NOTIFY = &H1&
Global Const LBS_SORT = &H2&
Global Const LBS_NOREDRAW = &H4&
Global Const LBS_MULTIPLESEL = &H8&
Global Const LBS_OWNERDRAWFIXED = &H10&
Global Const LBS_OWNERDRAWVARIABLE = &H20&
Global Const LBS_HASSTRINGS = &H40&
Global Const LBS_USETABSTOPS = &H80&
Global Const LBS_NOINTEGRALHEIGHT = &H100&
Global Const LBS_MULTICOLUMN = &H200&
Global Const LBS_WANTKEYBOARDINPUT = &H400&
Global Const LBS_EXTENDEDSEL = &H800&
'global Const LBS_STANDARD = (LBS_NOTIFY Or LBS_SORT Or WS_VSCROLL Or WS_BORDER)
'
'Windows 3.1 Additions
Global Const LBS_DISABLENOSCROLL = &H1000&
'
'Windows System Colors
Global Const COLOR_SCROLLBAR = 0
Global Const COLOR_BACKGROUND = 1
Global Const COLOR_ACTIVECAPTION = 2
Global Const COLOR_INACTIVECAPTION = 3
Global Const COLOR_MENU = 4
Global Const COLOR_WINDOW = 5
Global Const COLOR_WINDOWFRAME = 6
Global Const COLOR_MENUTEXT = 7
Global Const COLOR_WINDOWTEXT = 8
Global Const COLOR_CAPTIONTEXT = 9
Global Const COLOR_ACTIVEBORDER = 10
Global Const COLOR_INACTIVEBORDER = 11
Global Const COLOR_APPWORKSPACE = 12
Global Const COLOR_HIGHLIGHT = 13
Global Const COLOR_HIGHLIGHTTEXT = 14
Global Const COLOR_BTNFACE = 15
Global Const COLOR_BTNSHADOW = 16
Global Const COLOR_GRAYTEXT = 17
Global Const COLOR_BTNTEXT = 18
Global Const COLOR_ENDCOLORS = COLOR_BTNTEXT
'Windows 3.1 additions
Global Const COLOR_INACTIVECAPTIONTEXT = 19
Global Const COLOR_BTNHIGHLIGHT = 20

'  Owner draw actions
Global Const ODA_DRAWENTIRE = &H1
Global Const ODA_SELECT = &H2
Global Const ODA_FOCUS = &H4

'  Owner draw state
Global Const ODS_SELECTED = &H1
Global Const ODS_GRAYED = &H2
Global Const ODS_DISABLED = &H4
Global Const ODS_CHECKED = &H8
Global Const ODS_FOCUS = &H10

Declare Function DrawText Lib "User" (ByVal hDC As Integer, ByVal lpStr As String, ByVal nCount As Integer, lpRect As RECT, ByVal wFormat As Integer) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Sub DrawFocusRect Lib "User" (ByVal hDC As Integer, lpRect As RECT)
Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long
Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function FillRect Lib "User" (ByVal hDC As Integer, lpRect As RECT, ByVal hBrush As Integer) As Integer
Declare Function SetBkColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function SetTextColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer

