VERSION 2.00
Begin Form fEZPrint 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Replacement for the Printer Object"
   ClientHeight    =   6525
   ClientLeft      =   675
   ClientTop       =   390
   ClientWidth     =   7425
   Height          =   6990
   Left            =   585
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6525
   ScaleWidth      =   7425
   Top             =   15
   Width           =   7605
   Begin vsViewPort vsViewPort2 
      BackColor       =   &H00808080&
      Height          =   3795
      Left            =   420
      Top             =   1260
      VirtualHeight   =   7410
      VirtualWidth    =   0
      Width           =   1905
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Line by Line"
         Height          =   645
         Index           =   0
         Left            =   105
         TabIndex        =   16
         Top             =   105
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Paragraph"
         Height          =   645
         Index           =   1
         Left            =   105
         TabIndex        =   15
         Top             =   840
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Tables"
         Height          =   645
         Index           =   2
         Left            =   105
         TabIndex        =   14
         Top             =   1575
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Multi-Columns"
         Height          =   645
         Index           =   3
         Left            =   105
         TabIndex        =   13
         Top             =   2310
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Draw"
         Height          =   645
         Index           =   4
         Left            =   105
         TabIndex        =   12
         Top             =   5250
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "&AlignText"
         Height          =   645
         Index           =   5
         Left            =   105
         TabIndex        =   11
         Top             =   3045
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "&Indent"
         Height          =   645
         Index           =   6
         Left            =   105
         TabIndex        =   10
         Top             =   3780
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "&Mail Merge"
         Height          =   645
         Index           =   7
         Left            =   105
         TabIndex        =   9
         Top             =   4515
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "&Graphics"
         Height          =   645
         Index           =   8
         Left            =   105
         TabIndex        =   8
         Top             =   5985
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Angle"
         Height          =   645
         Index           =   10
         Left            =   105
         TabIndex        =   7
         Top             =   6720
         Width           =   1380
      End
   End
   Begin CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Order Form"
      Height          =   540
      Index           =   9
      Left            =   420
      TabIndex        =   0
      Top             =   5250
      Width           =   1905
   End
   Begin ComboBox cmbOrientation 
      Enabled         =   0   'False
      Height          =   300
      Left            =   3360
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   105
      Width           =   1065
   End
   Begin CommandButton cmdPrint 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Print"
      Enabled         =   0   'False
      Height          =   330
      Left            =   6195
      TabIndex        =   3
      Top             =   105
      Width           =   1065
   End
   Begin vsViewPort vsViewPort1 
      BackColor       =   &H00808080&
      Height          =   5895
      Left            =   2625
      Top             =   525
      VirtualHeight   =   0
      VirtualWidth    =   0
      Width           =   4635
      Begin vsPrinter VSPrinter1 
         AbortCaption    =   ""
         BackColor       =   &H00FFFFFF&
         BrushColor      =   &H0080FFFF&
         FontName        =   "Arial"
         FontSize        =   40
         Footer          =   "||Page %d"
         HdrColor        =   &H00800000&
         HdrFontBold     =   -1  'True
         HdrFontItalic   =   -1  'True
         HdrFontName     =   "Arial"
         HdrFontSize     =   24
         Header          =   "|VideoSoft VSView"
         Height          =   4005
         Left            =   255
         PenColor        =   &H00808080&
         PenWidth        =   20
         TableSep        =   "|;"
         Top             =   210
         Width           =   2850
      End
   End
   Begin ComboBox cmbZoom 
      Enabled         =   0   'False
      Height          =   300
      Left            =   5040
      Style           =   2  'Dropdown List
      TabIndex        =   2
      Top             =   105
      Width           =   960
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Orient."
      ForeColor       =   &H00000000&
      Height          =   195
      Index           =   2
      Left            =   2730
      TabIndex        =   6
      Top             =   105
      Width           =   615
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Zoom"
      ForeColor       =   &H00000000&
      Height          =   195
      Index           =   1
      Left            =   4515
      TabIndex        =   5
      Top             =   105
      Width           =   495
   End
   Begin Image Image1 
      Height          =   375
      Left            =   105
      Picture         =   FEZPRINT.FRX:0000
      Top             =   105
      Width           =   345
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "VSPrinter: The Visual Printer"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   13.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00800000&
      Height          =   1275
      Index           =   0
      Left            =   630
      TabIndex        =   4
      Top             =   105
      Width           =   1800
   End
End
Option Explicit

Dim MyPage%         'Keep the output view to be printed
Dim OldOrientation  'Don't mess with my printer settings

Sub cmbOrientation_Click ()
  mousepointer = 11
  vsPrinter1.Orientation = cmbOrientation.ListIndex
  cmbZoom_click
  If MyPage >= 0 Then command1_click MyPage

  mousepointer = 0
End Sub

Sub cmbZoom_click ()
  
  vsPrinter1.Visible = False
  mousepointer = 11
    
  'Change the screen size to zoom value
  vsPrinter1.Width = vsPrinter1.PageWidth * Val(cmbZoom) / 100
  vsPrinter1.Height = vsPrinter1.PageHeight * Val(cmbZoom) / 100
  vsViewPort1.VirtualWidth = vsPrinter1.Width + 400
  vsViewPort1.VirtualHeight = vsPrinter1.Height + 400

  ' center picture if it's small
  If vsPrinter1.Width < vsViewPort1.Width Then vsPrinter1.Left = (vsViewPort1.Width - vsPrinter1.Width) / 2
  If vsPrinter1.Height < vsViewPort1.Height Then vsPrinter1.Top = (vsViewPort1.Height - vsPrinter1.Height) / 2
  
  mousepointer = 0
  vsPrinter1.Visible = True

End Sub

Sub cmdPrint_Click ()
  
  mousepointer = 11
  
  ' Cancel Preview mode and print
  vsPrinter1.Preview = False
  command1_click MyPage
  vsPrinter1.Preview = True

  mousepointer = 0

End Sub

Sub command1_click (Index%)
      
  cmbZoom.Enabled = True
  cmdPrint.Enabled = True
  cmbOrientation.Enabled = True

  MyPage = Index%

  vsPrinter1.Action = 3 'Start Document
  mousepointer = 11

  Select Case Index

    Case 0
      DoLine

    Case 1
      DoParagraph

    Case 2
      DoTable

    Case 3
      DoColumns

    Case 4
      DoDrawing

    Case 5
      DoAlign
    
    Case 6
      DoIndent

    Case 7
      DoMailMerge "Joe Smith", "Chief Financial Officer"
      DoMailMerge "Mary Kerney", "President"

    Case 8
      DoGraphics
    
    Case 9
      DoOrder
    
    Case 10
      DoAngle


  End Select
  
  vsPrinter1.Action = 6 'End Document
  mousepointer = 0

End Sub

Sub DoAlign ()
      
      vsPrinter1.SpaceAfter = 500
      vsPrinter1.TextColor = QBColor(1)
      vsPrinter1.TextAlign = 1  'Center
      vsPrinter1.FontUnderline = True
      vsPrinter1.Paragraph = ""
      vsPrinter1.Paragraph = "VSPrinter automatically aligns proportional fonts"
      vsPrinter1.FontUnderline = False
      
      vsPrinter1.TextColor = QBColor(0)
      vsPrinter1.CurrentY = vsPrinter1.PageHeight / 2
      vsPrinter1.TextAlign = 2  'Rigth
      vsPrinter1.Paragraph = "Text is right aligned"
      vsPrinter1.TextAlign = 1  'Center
      vsPrinter1.Paragraph = "Text is centered"
      vsPrinter1.TextAlign = 0  'Left
      vsPrinter1.Paragraph = "Text is left aligned"
      vsPrinter1.SpaceAfter = 0

End Sub

Sub DoAngle ()

  Dim i%, j%

      vsPrinter1.TextAngle = 450
      vsPrinter1 = ""
      vsPrinter1 = ""
      vsPrinter1 = ""
      vsPrinter1 = ""
      vsPrinter1 = "Rotate text"
      vsPrinter1 = "to any angle"

      
      'Rotate Text
      j = 1
      For i = 450 To 3600 Step 900
        vsPrinter1.TextColor = QBColor(j)
        vsPrinter1.CurrentX = vsPrinter1.PageWidth * .5
        vsPrinter1.CurrentY = vsPrinter1.PageHeight * .5
        vsPrinter1.TextAngle = i
        vsPrinter1.Text = "VSView"
        j = j + 1
      Next

      vsPrinter1.TextAngle = 0
      vsPrinter1.TextColor = 0

End Sub

Sub DoColumns ()
      Dim s$, i%

      s = "VSPrinter can also print in multiple columns. "
      s = s + "You have control over column breaks, and you can save "
      s = s + "a whole lot of paper by using multiple columns."
      
      
      vsPrinter1.Columns = 2
      vsPrinter1.PageBorder = 5
      
      
      vsPrinter1.TextColor = QBColor(1)
      vsPrinter1 = s
      vsPrinter1 = ""
      vsPrinter1.TextColor = QBColor(0)
      vsPrinter1 = s

      'Restore settings
      vsPrinter1.Columns = 1
      vsPrinter1.PageBorder = 3

End Sub

Sub DoDrawing ()
      Dim s$, x%, y%

      vsPrinter1.CurrentX = vsPrinter1.PageWidth / 2
      vsPrinter1.CurrentY = vsPrinter1.PageHeight / 2

      vsPrinter1.TextAlign = 1              ' Center
      vsPrinter1.TextColor = &H800000       'Blue
      vsPrinter1 = "Add graphics to your reports!"
      vsPrinter1.TextColor = &H0&           'Black
      vsPrinter1 = "With VSPrinter, it's easy!"
      vsPrinter1.TextAlign = 0              ' Left

      vsPrinter1.X1 = vsPrinter1.PageWidth / 4 * .25
      vsPrinter1.Y1 = vsPrinter1.PageHeight / 4 * .25
      vsPrinter1.X2 = vsPrinter1.PageWidth / 4 * 1.25
      vsPrinter1.Y2 = vsPrinter1.PageHeight / 4 * 1.25
      vsPrinter1.BrushColor = &HFF&         'Red
      vsPrinter1.BrushStyle = 6             'Cross
      vsPrinter1.Draw = 3                   'Circle

      vsPrinter1.X1 = vsPrinter1.PageWidth * .7
      vsPrinter1.Y1 = vsPrinter1.PageHeight * .7
      vsPrinter1.X2 = vsPrinter1.PageWidth * .9
      vsPrinter1.Y2 = vsPrinter1.PageHeight * .9
      vsPrinter1.BrushColor = &H800080      'Purple
      vsPrinter1.BrushStyle = 7             'Cross Diagonal
      vsPrinter1.Draw = 2                   'Rect.

      ' complex graphics
      s = ""
      For x = vsPrinter1.MarginLeft To vsPrinter1.PageWidth - vsPrinter1.MarginRight Step 20
        y = 6000 + Cos(x * 3.1416 / 180) * (x - vsPrinter1.PageWidth / 2) / 10
        s = s + Str(x) + Str(y)
      Next
      vsPrinter1.PenWidth = 10
      vsPrinter1.PolyLine = s
      vsPrinter1.PenWidth = 0

End Sub

Sub DoGraphics ()
  Dim s$, fmt$

  
  ' Print Title
  vsPrinter1 = ""
  vsPrinter1.CurrentX = 2500
  vsPrinter1.TextColor = QBColor(1)
  vsPrinter1 = "Metafiles and Bitmaps"
  vsPrinter1.TextColor = QBColor(0)

  vsPrinter1.FontSize = 28
  vsPrinter1 = ""
  vsPrinter1 = "You can now print and preview reports that includes bitmaps and metafiles.  With VSView, who needs desktop publishing. <g>"
  vsPrinter1 = ""

  'Place pictures--------------------------
  vsPrinter1.X1 = 1000
  vsPrinter1.Y1 = 1000
  vsPrinter1.X2 = 2400
  vsPrinter1.Y2 = 2400
  vsPrinter1.Picture = ftoolbox!Picture1(1).Picture
      
  vsPrinter1.FontSize = 40
End Sub

Sub DoIndent ()
  
  vsPrinter1.IndentFirst = 1000
  vsPrinter1 = "You can automatically indent the FIRST LINE of the paragraph."
  vsPrinter1 = ""

  vsPrinter1.IndentFirst = 0
  vsPrinter1.IndentLeft = 1000
  vsPrinter1 = "You can automatically indent from the LEFT margin of the paragraph."
  vsPrinter1 = ""
  
  vsPrinter1.IndentLeft = 0
  vsPrinter1.IndentRight = 1000
  vsPrinter1 = "You can automatically indent from the RIGHT margin of the paragraph."
  vsPrinter1 = ""

  vsPrinter1.IndentLeft = 1000
  vsPrinter1.IndentFirst = 1500
  vsPrinter1 = "You can even combined all levels of indentation."

  'Restore Values
  vsPrinter1.IndentLeft = 0
  vsPrinter1.IndentFirst = 0
  vsPrinter1.IndentRight = 0

End Sub

Sub DoLine ()
      
      vsPrinter1.TextColor = 0
      vsPrinter1 = ""
      vsPrinter1.Text = "With VSPrinter you can print"

      vsPrinter1.FontBold = True
      vsPrinter1.TextColor = QBColor(2)
      vsPrinter1.Text = " Line by Line"
      vsPrinter1.TextColor = QBColor(0)
      vsPrinter1.FontBold = False

      vsPrinter1.Text = " just like you would in VB."
      vsPrinter1.Text = " Text wraps automatically, so your life becomes easier."

End Sub

Sub DoMailMerge (FullName$, Position$)
  
  vsPrinter1 = Format$(Now, "mmmm d, yyyy")
  vsPrinter1 = ""
  vsPrinter1 = "This letter is to inform that " & FullName & " has been promoted as " & Position & " of this company."
  vsPrinter1 = ""

End Sub

Sub DoOrder ()
  Dim fmt$, s$

  vsPrinter1.FontSize = 24
  vsPrinter1 = ""

  vsPrinter1.FontBold = True
  vsPrinter1.FontUnderline = True
  vsPrinter1 = "VSView Order Form"
  vsPrinter1.FontBold = False
  vsPrinter1.FontUnderline = False
  
  '---------------------------------------------------------------
  vsPrinter1.PenWidth = 2
  vsPrinter1.TableBorder = 5
  vsPrinter1.FontSize = 11

  vsPrinter1 = ""
  vsPrinter1 = ""
  vsPrinter1 = "Please rush my copy of VSView to the following address:"
  vsPrinter1 = ""
  
  fmt = "2500|>4000;"
  s = fmt
  s = s + "Name|;"
  s = s + "Company|;"
  s = s + "Address|;"
  s = s + "|;"
  s = s + "|;"
  s = s + "|;"
  s = s + "Phone|;"
  s = s + "Fax|;"
  s = s + "Credit Card #|;"
  s = s + "Expiration Date|;"
  s = s + "Comments|;"
  s = s + "|;"
  s = s + "|;"
  
  vsPrinter1.Table = s

  
  vsPrinter1 = ""
  vsPrinter1 = ""
  vsPrinter1 = "Fax your credit card order to 510-547-1084 or mail your check or money order to: VideoSoft, 2625 Alcatraz Avenue, Suite 271, Berkeley, California 94705.  Sorry no CODs."
  vsPrinter1 = ""

  vsPrinter1.TableBorder = 7
  
  fmt = "4000|>2000|>2000;"
  s = fmt
  s = s + "Single Developer||US$99.00;"
  s = s + "Additional Developers|___ x 99.00|;"
  s = s + "Shipping and Handling Domestic|US$6.00|;"
  s = s + "Shipping and Handling International|US$10.00|;"
  s = s + "8.5% tax (CA residents only)||;"
  s = s + "|TOTAL|;"
  
  vsPrinter1.TextAlign = 1  'Center
  vsPrinter1.Table = s

  'Restore settings
  vsPrinter1.TextAlign = 0  'Left
  vsPrinter1.TableBorder = 7
  vsPrinter1.FontSize = 40
  vsPrinter1.PenWidth = 20

End Sub

Sub DoParagraph ()

      Dim s$

      s = "You can print whole paragraphs at once! This is very easy. "
      
      vsPrinter1 = s + s
      vsPrinter1 = ""
      vsPrinter1 = "VSPrinter takes care of indentation, wrapping, spacing, etc."

End Sub

Sub DoTable ()
  Dim s$, fmt$

  ' Print Title
  vsPrinter1 = ""
  vsPrinter1 = "Print by Table"

  vsPrinter1.FontSize = 22
  
  vsPrinter1 = ""
  vsPrinter1 = "You can now print reports that includes paragraphs and tables.  With VSView, printing a grid it is very easy."
  vsPrinter1 = ""

  '---------------------------------------------------------------
  
  'Set sizes and justification
  fmt = "2500|>1600|^1600|>2100|>2200;"                   '^Center > Right
  s = fmt + "Product|Code|Region|Units Sold|Revenue;"     'Set header
  s = s + "Spam in a Can|00012|North|  372|$23,542;"
  s = s + "Flipper Tuna|00231|North|  832|$44,432;"
  s = s + "Jiffy Lubed Butter |00978|North|  452|$53,535;"
  s = s + "Saturn Bars|00543|North|  654|$12,535;"

  vsPrinter1.PenWidth = 8
  vsPrinter1.TextAlign = 1  'Center
  vsPrinter1.FontSize = 18
  vsPrinter1.Table = s
  
  vsPrinter1.TextAlign = 0        'Left
  vsPrinter1 = ""
  vsPrinter1 = "The table's cells could be aligned the way you want to."
  
  'Restore Values
  vsPrinter1.FontSize = 40

End Sub

Sub DoTitle ()
  
  vsPrinter1.Action = 3 'Start Document

  vsPrinter1.CurrentX = vsPrinter1.PageWidth / 2
  vsPrinter1.CurrentY = vsPrinter1.PageHeight / 2
  vsPrinter1.TextAlign = 1 'Center

  vsPrinter1.TextColor = QBColor(2)
  vsPrinter1.Paragraph = "VideoSoft VSPrinter"
  vsPrinter1.TextColor = QBColor(0)
  vsPrinter1.Paragraph = ""
  vsPrinter1.Paragraph = "Click on any button"

  vsPrinter1.TextAlign = 0 'Left

  vsPrinter1.Action = 6 'End Document

End Sub

Sub Form_Load ()

  OldOrientation = vsPrinter1.Orientation
  
  MyPage = -1    'No pages selected

  vsPrinter1.Preview = True
  vsPrinter1.PreviewPage = 1

  cmbZoom.AddItem "35"
  cmbZoom.AddItem "50"
  cmbZoom.AddItem "75"
  cmbZoom.AddItem "100"
  cmbZoom.AddItem "150"
  cmbZoom.AddItem "200"
  cmbZoom.ListIndex = 0

  cmbOrientation.AddItem "Portrait"
  cmbOrientation.AddItem "Landscape"
  cmbOrientation.ListIndex = 0

  MyPage = 0    'Default to first button

End Sub

Sub Form_Unload (Cancel As Integer)
  'Restore priner orientation
  vsPrinter1.Orientation = OldOrientation
End Sub

Sub VSPrinter1_NewTableCell (Row As Integer, Column As Integer, Cell As String)
  
  'Change the TextColor of the first row when printing Table Example
  If MyPage <> 2 Then Exit Sub
  
  If Row = 1 Then
    vsPrinter1.TextColor = QBColor(Column)
  Else
    vsPrinter1.TextColor = 1
  End If

End Sub

